<?php

/**
 * Product: sonnb - Stop Spam Here
 * Version: 1.2.3
 * Date: 27th Jan 2013
 * Author: sonnb
 * Website: www.sonnb.com - www.UnderWorldVN.com
 * License: You might not copy or redistribute this addon. 
 * ********* Any action to public or redistribute must be authorized from author
 * ********* One copy is valid for one board only*********
 */
class sonnbStopSpamHere_ControllerAdmin_StopSpamHere extends XenForo_ControllerAdmin_Abstract
{

    protected function _preDispatch($action)
    {
        $this->assertAdminPermission('viewLogs');
    }

    public function actionIndex()
    {
        $page = max(1,$this->_input->filterSingle('page', XenForo_Input::UINT));
        $perPage = 50;

        $offset = ($page-1) * $perPage;

        $log = $this->_getLogModel()->getLogs($perPage, $offset);

        $viewParams = array(
            'page' => $page,
            'perPage' => $perPage,
            'total' => $this->_getLogModel()->countTotal(),
            'logs' => $log
        );

        return $this->responseView('', 'sonnbStopSpamHere_log_index', $viewParams);
    }

    public function actionClear()
    {
        $this->_getLogModel()->clean();
        return $this->responseRedirect(
                XenForo_ControllerResponse_Redirect::SUCCESS, 
                XenForo_Link::buildAdminLink('stop-spam-here/index')
        );
    }
    
    public function actionDelete()
    {
        $id = $this->_input->filterSingle('id', XenForo_Input::UINT);
        
        if ($id)
        {     
            $writer_log = XenForo_DataWriter::create('sonnbStopSpamHere_DataWriter_Log');
            $writer_log->setExistingData($id);
            $writer_log->delete();
            
            return $this->responseRedirect(
                    XenForo_ControllerResponse_Redirect::SUCCESS,
                    XenForo_Link::buildAdminLink('stop-spam-here/index')
            );
        }
        
        return $this->responseError(new XenForo_Phrase('invalid_id_selected'));
    }

    public function actionView()
    {
        $id = $this->_input->filterSingle('id', XenForo_Input::UINT);
        $log = $this->_getLogModel()->getLog($id);
        
        if ($log)
        {
            $viewParams = array(
                'log' => $log
            );
            return $this->responseView('', 'sonnbStopSpamHere_log_view', $viewParams);
        }

        return $this->responseError('Requested Log was not found', 404);
    }

    protected function _getLogModel()
    {
        return XenForo_Model::create('sonnbStopSpamHere_Model_Log');
    }

}